/* --COPYRIGHT--,BSD
 * Copyright (c) 2014, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/


/******************************************************************************/
/* lnk_msp430f2617.cmd - LINKER COMMAND FILE FOR LINKING MSP430F2617 PROGRAMS     */
/*                                                                            */
/*   Usage:  lnk430 <obj files...>    -o <out file> -m <map file> lnk.cmd     */
/*           cl430  <src files...> -z -o <out file> -m <map file> lnk.cmd     */
/*                                                                            */
/*----------------------------------------------------------------------------*/
/* These linker options are for command line linking only.  For IDE linking,  */
/* you should set your linker options in Project Properties                   */
/* -c                                               LINK USING C CONVENTIONS  */
/* -stack  0x0100                                   SOFTWARE STACK SIZE       */
/* -heap   0x0100                                   HEAP AREA SIZE            */
/*                                                                            */
/*----------------------------------------------------------------------------*/


/****************************************************************************/
/* SPECIFY THE SYSTEM MEMORY MAP                                            */
/****************************************************************************/

MEMORY
{
    SFR                     : origin = 0x0000, length = 0x0010
    PERIPHERALS_8BIT        : origin = 0x0010, length = 0x00F0
    PERIPHERALS_16BIT       : origin = 0x0100, length = 0x0100
    RAM                     : origin = 0x1200, length = 0x1F00 // removed first 0x100
    RAM01					: origin = 0x1158, length = 0x04   // G_FIRMWARE_VERSION
	RAM02					: origin = 0x115c  length = 0x04   // G_IFS
	RAM03					: origin = 0x1160  length = 0x04   // G_IRSENSE
	RAM04					: origin = 0x1164  length = 0x04   // G_VREF_VAL
	RAM05					: origin = 0x119c  length = 0x02   // G_ACCEL_RATE
	RAM06					: origin = 0x119e  length = 0x02   // G_ADECAY
	RAM07					: origin = 0x11a0  length = 0x02   // G_NUM_STEPS
	RAM08					: origin = 0x11a2  length = 0x02   // G_PWM_OFF_TIME
	RAM09					: origin = 0x11a4  length = 0x02   // G_STARTING_SPEED
	RAM10					: origin = 0x11a6  length = 0x02   // G_STEPS_2_STOP
	RAM11					: origin = 0x11a8  length = 0x02   // G_STEP_MODE
	RAM12					: origin = 0x11aa  length = 0x02   // G_STOPPING_SPEED
	RAM13					: origin = 0x11ac  length = 0x02   // G_TARGET_SPEED
	RAM14					: origin = 0x11ae  length = 0x02   // G_TORQUE
	RAM15					: origin = 0x11ba, length = 0x02   // G_DIR
	RAM16					: origin = 0x11bc, length = 0x02   // G_ENABLE
	RAM17					: origin = 0x11ce, length = 0x02   // G_ENABLE_MTR_CONTROL
	RAM18					: origin = 0x11c4, length = 0x02   // G_ENBL_MOVE_STEPS
	RAM19					: origin = 0x11c2, length = 0x02   // G_ENBL_START_STOP
	RAM20					: origin = 0x11be, length = 0x02   // G_FAULT
	RAM21					: origin = 0x11cc, length = 0x02   // G_MANUAL_ADVANCE
	RAM22					: origin = 0x11c6, length = 0x02   // G_MOTOR_CMD_ACTIVE1
	RAM23					: origin = 0x11c8, length = 0x02   // G_MOTOR_CMD_ACTIVE2
	RAM24					: origin = 0x11c0, length = 0x02   // G_ADEC
	RAM25					: origin = 0x11ca, length = 0x02   // G_RUN_MOTOR
	RAM26					: origin = 0x11b8, length = 0x02   // G_WAKE
	RAM27                   : origin = 0x11d0, length = 0x02   // G_MOTOR_CMD_ACTIVE3
	RAM28                   : origin = 0x11d2, length = 0x02   // G_RECIPROCATION
	RAM29                   : origin = 0x11d4, length = 0x02   // G_ENBL_RECIPROCATION_BUTTON
	RAM30                   : origin = 0x11d6, length = 0x02   // G_BDECAY
	RAM31                   : origin = 0x11d8, length = 0x02   // G_ICHOP
	RAM32                   : origin = 0x11da, length = 0x02   // G_IDLE
    INFOA                   : origin = 0x10C0, length = 0x0040
    INFOB                   : origin = 0x1080, length = 0x0040
    INFOC                   : origin = 0x1040, length = 0x0040
    INFOD                   : origin = 0x1000, length = 0x0040
    FLASH                   : origin = 0x3100, length = 0xCEBE
    FLASH2                  : origin = 0x10000,length = 0xA000
    INT00                   : origin = 0xFFC0, length = 0x0002
    INT01                   : origin = 0xFFC2, length = 0x0002
    INT02                   : origin = 0xFFC4, length = 0x0002
    INT03                   : origin = 0xFFC6, length = 0x0002
    INT04                   : origin = 0xFFC8, length = 0x0002
    INT05                   : origin = 0xFFCA, length = 0x0002
    INT06                   : origin = 0xFFCC, length = 0x0002
    INT07                   : origin = 0xFFCE, length = 0x0002
    INT08                   : origin = 0xFFD0, length = 0x0002
    INT09                   : origin = 0xFFD2, length = 0x0002
    INT10                   : origin = 0xFFD4, length = 0x0002
    INT11                   : origin = 0xFFD6, length = 0x0002
    INT12                   : origin = 0xFFD8, length = 0x0002
    INT13                   : origin = 0xFFDA, length = 0x0002
    INT14                   : origin = 0xFFDC, length = 0x0002
    INT15                   : origin = 0xFFDE, length = 0x0002
    INT16                   : origin = 0xFFE0, length = 0x0002
    INT17                   : origin = 0xFFE2, length = 0x0002
    INT18                   : origin = 0xFFE4, length = 0x0002
    INT19                   : origin = 0xFFE6, length = 0x0002
    INT20                   : origin = 0xFFE8, length = 0x0002
    INT21                   : origin = 0xFFEA, length = 0x0002
    INT22                   : origin = 0xFFEC, length = 0x0002
    INT23                   : origin = 0xFFEE, length = 0x0002
    INT24                   : origin = 0xFFF0, length = 0x0002
    INT25                   : origin = 0xFFF2, length = 0x0002
    INT26                   : origin = 0xFFF4, length = 0x0002
    INT27                   : origin = 0xFFF6, length = 0x0002
    INT28                   : origin = 0xFFF8, length = 0x0002
    INT29                   : origin = 0xFFFA, length = 0x0002
    INT30                   : origin = 0xFFFC, length = 0x0002
    RESET                   : origin = 0xFFFE, length = 0x0002
}

/****************************************************************************/
/* SPECIFY THE SECTIONS ALLOCATION INTO MEMORY                              */
/****************************************************************************/

SECTIONS
{
    .bss        : {} > RAM                /* GLOBAL & STATIC VARS              */
    .data       : {} > RAM                /* GLOBAL & STATIC VARS              */
    .sysmem     : {} > RAM                /* DYNAMIC MEMORY ALLOCATION AREA    */
    .stack      : {} > RAM (HIGH)         /* SOFTWARE SYSTEM STACK             */

	.mysect01	: {} > RAM01			  /* sections to force common          */
	.mysect02	: {} > RAM02			  /* across all versions			   */
	.mysect03	: {} > RAM03
	.mysect04	: {} > RAM04
	.mysect05	: {} > RAM05
	.mysect06	: {} > RAM06
	.mysect07	: {} > RAM07
	.mysect08	: {} > RAM08
	.mysect09	: {} > RAM09
	.mysect10	: {} > RAM10
	.mysect11	: {} > RAM11
	.mysect12	: {} > RAM12
	.mysect13	: {} > RAM13
	.mysect14	: {} > RAM14
	.mysect15	: {} > RAM15
	.mysect16	: {} > RAM16
	.mysect17	: {} > RAM17
	.mysect18	: {} > RAM18
	.mysect19	: {} > RAM19
	.mysect20	: {} > RAM20
	.mysect21	: {} > RAM21
	.mysect22	: {} > RAM22
	.mysect23	: {} > RAM23
	.mysect24	: {} > RAM24
	.mysect25	: {} > RAM25
	.mysect26	: {} > RAM26
	.mysect27	: {} > RAM27
	.mysect28	: {} > RAM28
	.mysect29	: {} > RAM29
	.mysect30	: {} > RAM30
	.mysect31   : {} > RAM31
	.mysect32   : {} > RAM32

    .text       : {}>> FLASH | FLASH2     /* CODE                              */
    .text:_isr  : {} > FLASH              /* ISR CODE SPACE                    */
#ifdef __LARGE_DATA_MODEL__
    .cinit      : {} > FLASH | FLASH2     /* INITIALIZATION TABLES             */
    .const      : {} > FLASH | FLASH2     /* CONSTANT DATA                     */
#else
    .cinit      : {} > FLASH              /* INITIALIZATION TABLES             */
    .const      : {} > FLASH              /* CONSTANT DATA                     */
#endif
    .cio        : {} > RAM                /* C I/O BUFFER                      */

    .pinit      : {} > FLASH              /* C++ CONSTRUCTOR TABLES            */
    .init_array : {} > FLASH              /* C++ CONSTRUCTOR TABLES            */
    .mspabi.exidx : {} > FLASH            /* C++ CONSTRUCTOR TABLES            */
    .mspabi.extab : {} > FLASH            /* C++ CONSTRUCTOR TABLES            */

    .infoA     : {} > INFOA              /* MSP430 INFO FLASH MEMORY SEGMENTS */
    .infoB     : {} > INFOB
    .infoC     : {} > INFOC
    .infoD     : {} > INFOD

    /* MSP430 INTERRUPT VECTORS          */
    RESERVED0    : { * ( .int00 ) } > INT00 type = VECT_INIT
    RESERVED1    : { * ( .int01 ) } > INT01 type = VECT_INIT
    RESERVED2    : { * ( .int02 ) } > INT02 type = VECT_INIT
    RESERVED3    : { * ( .int03 ) } > INT03 type = VECT_INIT
    RESERVED4    : { * ( .int04 ) } > INT04 type = VECT_INIT
    RESERVED5    : { * ( .int05 ) } > INT05 type = VECT_INIT
    RESERVED6    : { * ( .int06 ) } > INT06 type = VECT_INIT
    RESERVED7    : { * ( .int07 ) } > INT07 type = VECT_INIT
    RESERVED8    : { * ( .int08 ) } > INT08 type = VECT_INIT
    RESERVED9    : { * ( .int09 ) } > INT09 type = VECT_INIT
    RESERVED10   : { * ( .int10 ) } > INT10 type = VECT_INIT
    RESERVED11   : { * ( .int11 ) } > INT11 type = VECT_INIT
    RESERVED12   : { * ( .int12 ) } > INT12 type = VECT_INIT
    RESERVED13   : { * ( .int13 ) } > INT13 type = VECT_INIT
    DAC12        : { * ( .int14 ) } > INT14 type = VECT_INIT
    DMA          : { * ( .int15 ) } > INT15 type = VECT_INIT
    USCIAB1TX    : { * ( .int16 ) } > INT16 type = VECT_INIT
    USCIAB1RX    : { * ( .int17 ) } > INT17 type = VECT_INIT
    PORT1        : { * ( .int18 ) } > INT18 type = VECT_INIT
    PORT2        : { * ( .int19 ) } > INT19 type = VECT_INIT
    RESERVED20   : { * ( .int20 ) } > INT20 type = VECT_INIT
    ADC12        : { * ( .int21 ) } > INT21 type = VECT_INIT
    USCIAB0TX    : { * ( .int22 ) } > INT22 type = VECT_INIT
    USCIAB0RX    : { * ( .int23 ) } > INT23 type = VECT_INIT
    TIMERA1      : { * ( .int24 ) } > INT24 type = VECT_INIT
    TIMERA0      : { * ( .int25 ) } > INT25 type = VECT_INIT
    WDT          : { * ( .int26 ) } > INT26 type = VECT_INIT
    COMPARATORA   : { * ( .int27 ) } > INT27 type = VECT_INIT
    TIMERB1      : { * ( .int28 ) } > INT28 type = VECT_INIT
    TIMERB0      : { * ( .int29 ) } > INT29 type = VECT_INIT
    NMI          : { * ( .int30 ) } > INT30 type = VECT_INIT
    .reset       : {}               > RESET  /* MSP430 RESET VECTOR         */ 
}

/****************************************************************************/
/* INCLUDE PERIPHERALS MEMORY MAP                                           */
/****************************************************************************/

-l msp430f2617.cmd

